from matplotlib import pyplot as plt
import pandas as pd

plt.style.use("fivethirtyeight")

# excellent for visualizing the distribution of data
# where the data falls within certain boundaries
# similar to bar graph, but groups the data into bins
# instead of plotting each individual value

# histograms allow us to create bins, whereas bar graphs do not

ages = [18,19,21,25,26,26,30,32,38,45,55]

# auto bins
# plt.hist(ages)

# specify an integer, and the hist functions will divide our data into that number of bins
# divide into 5 groups, and see how many responders fall into each group
# specify edgecolor property to divide bins a bit better
# plt.hist(ages, bins=5, edgecolor='black')

# specify you own values to create bins
# bins = [10,20,30,40,50,60]
# plt.hist(ages, bins=bins, edgecolor='black')

# we can exclude data from the graph, just remove the values from the bin
bins = [20,30,40,50,60]
plt.hist(ages, bins=bins, edgecolor='black')

plt.title("Ages of Respondents")
plt.xlabel("Ages")
plt.ylabel("Total responders")
plt.tight_layout()
plt.show()